// Operating System : Windows XP or later, 
// Scilab           : 5.3.3 


//Simulation of Central Limit Theorem.
//(Which says that if we keep on adding independant Random Variables then it density function 
//approches to gaussian distribution)
//here two uniform RVs are added.

clc;
clear all;
clf();
n = 0:0.01:1;
x = zeros(length(n),1);
i = 1:50;//length of Uniform rv 1
x(i)= 2;
subplot(3,3,1);
plot(n,x,'r-d')
xlabel('pdf');ylabel('pdf of rv 1')
title('pdf of rv 1 ');

y = zeros(length(n),1);
j = 1:50;
y(j)= 1*2;//length of Uniform rv 2
subplot(3,3,2);
plot(n,y,'bo-.')
xlabel('pdf');
ylabel('pdf of rv 2')
title('pdf of rv 2');

z1 = convol(x,y);
subplot(3,3,3)
//When two independent RVs are added their joint density is convolution of marginal density
plot(z1)
xlabel('rv value');
ylabel('pdf')
title('joint pdf of rv 1 and rv 2');

for i = 4:9 // adding rv 9 times
    subplot(3,3,i)
    z1 = convol(z1,y);
    plot(z1)
    xlabel('rv value');
    ylabel('pdf')
title('joint pdf');
end
